/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure2;

import java.util.Collection;
import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityHobbitFarmer;
import lotr.common.entity.npc.LOTREntityHobbitFarmhand;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure2.LOTRWorldGenHobbitStructure;
import lotr.common.world.structure2.LOTRWorldGenStructureBase2;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTRWorldGenHobbitFarm
extends LOTRWorldGenStructureBase2 {
    private Block wood1Block;
    private int wood1Meta;
    private Block wood1Stair;
    private Block beam1Block;
    private int beam1Meta;
    private Block wood2Block;
    private int wood2Meta;
    private Block cropBlock;
    private int cropMeta;
    private Item seedItem;

    public LOTRWorldGenHobbitFarm(boolean flag) {
        super(flag);
    }

    @Override
    public boolean generateWithSetRotation(World world, Random random, int i, int j, int k, int rotation) {
        int k15;
        int i13;
        int i1;
        int k12;
        int i12;
        int k14;
        int j1;
        int k13;
        int k16;
        int i14;
        this.setOriginAndRotation(world, i, j, k, rotation, 6);
        int randomWood = random.nextInt(4);
        switch (randomWood) {
            case 0: {
                this.wood1Block = Blocks.field_150344_f;
                this.wood1Meta = 0;
                this.wood1Stair = Blocks.field_150476_ad;
                this.beam1Block = LOTRMod.woodBeamV1;
                this.beam1Meta = 0;
                break;
            }
            case 1: {
                this.wood1Block = Blocks.field_150344_f;
                this.wood1Meta = 2;
                this.wood1Stair = Blocks.field_150487_bG;
                this.beam1Block = LOTRMod.woodBeamV1;
                this.beam1Meta = 2;
                break;
            }
            case 2: {
                this.wood1Block = LOTRMod.planks;
                this.wood1Meta = 0;
                this.wood1Stair = LOTRMod.stairsShirePine;
                this.beam1Block = LOTRMod.woodBeam1;
                this.beam1Meta = 0;
                break;
            }
            case 3: {
                this.wood1Block = LOTRMod.planks;
                this.wood1Meta = 4;
                this.wood1Stair = LOTRMod.stairsApple;
                this.beam1Block = LOTRMod.woodBeamFruit;
                this.beam1Meta = 0;
            }
        }
        int randomWood2 = random.nextInt(2);
        switch (randomWood2) {
            case 0: {
                this.wood2Block = Blocks.field_150344_f;
                this.wood2Meta = 1;
                break;
            }
            case 1: {
                this.wood2Block = LOTRMod.planks;
                this.wood2Meta = 6;
            }
        }
        int randomCrop = random.nextInt(8);
        switch (randomCrop) {
            case 0: {
                this.cropBlock = Blocks.field_150464_aj;
                this.cropMeta = 7;
                this.seedItem = Items.field_151014_N;
                break;
            }
            case 1: {
                this.cropBlock = Blocks.field_150459_bM;
                this.cropMeta = 7;
                this.seedItem = Items.field_151172_bF;
                break;
            }
            case 2: {
                this.cropBlock = Blocks.field_150469_bN;
                this.cropMeta = 7;
                this.seedItem = Items.field_151174_bG;
                break;
            }
            case 3: {
                this.cropBlock = LOTRMod.lettuceCrop;
                this.cropMeta = 7;
                this.seedItem = LOTRMod.lettuce;
                break;
            }
            case 4: {
                this.cropBlock = LOTRMod.pipeweedCrop;
                this.cropMeta = 7;
                this.seedItem = LOTRMod.pipeweedSeeds;
                break;
            }
            case 5: {
                this.cropBlock = LOTRMod.cornStalk;
                this.cropMeta = 0;
                this.seedItem = Item.func_150898_a((Block)LOTRMod.cornStalk);
                break;
            }
            case 6: {
                this.cropBlock = LOTRMod.leekCrop;
                this.cropMeta = 7;
                this.seedItem = LOTRMod.leek;
                break;
            }
            case 7: {
                this.cropBlock = LOTRMod.turnipCrop;
                this.cropMeta = 7;
                this.seedItem = LOTRMod.turnip;
            }
        }
        if (this.restrictions) {
            int minHeight = 1;
            int maxHeight = 1;
            for (i14 = -5; i14 <= 10; ++i14) {
                for (k16 = -7; k16 <= 8; ++k16) {
                    int j12 = this.getTopBlock(world, i14, k16);
                    Block block = this.getBlock(world, i14, j12 - 1, k16);
                    if (block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_150348_b) {
                        return false;
                    }
                    if (j12 > maxHeight) {
                        maxHeight = j12;
                    }
                    if (j12 >= minHeight) continue;
                    minHeight = j12;
                }
            }
            if (Math.abs(maxHeight - minHeight) > 6) {
                return false;
            }
        }
        for (int i15 = -5; i15 <= 10; ++i15) {
            for (k13 = -7; k13 <= 8; ++k13) {
                for (j1 = 1; j1 <= 10; ++j1) {
                    this.setAir(world, i15, j1, k13);
                }
                this.setBlockAndMetadata(world, i15, 0, k13, (Block)Blocks.field_150349_c, 0);
                this.setGrassToDirt(world, i15, -1, k13);
                j1 = -1;
                while (!this.isOpaque(world, i15, j1, k13) && this.getY(j1) >= 0) {
                    this.setBlockAndMetadata(world, i15, j1, k13, Blocks.field_150346_d, 0);
                    this.setGrassToDirt(world, i15, j1 - 1, k13);
                    --j1;
                }
            }
        }
        for (k14 = -5; k14 <= 6; ++k14) {
            for (i12 = -5; i12 <= 4; ++i12) {
                if (k14 != -5 && k14 != 6 && i12 != -5 && i12 != 4) continue;
                for (j1 = 1; j1 <= 5; ++j1) {
                    this.setBlockAndMetadata(world, i12, j1, k14, this.wood2Block, this.wood2Meta);
                    this.setGrassToDirt(world, i12, j1 - 1, k14);
                }
            }
        }
        for (int stair = 0; stair <= 4; ++stair) {
            int j13 = 5 + stair;
            for (i14 = -5 + stair; i14 <= 4 - stair; ++i14) {
                int[] nArray = new int[]{-5, 6};
                int n = nArray.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    int k17 = nArray[i2];
                    this.setBlockAndMetadata(world, i14, j13, k17, this.wood2Block, this.wood2Meta);
                }
            }
            for (k12 = -6; k12 <= 7; ++k12) {
                this.setBlockAndMetadata(world, -6 + stair, j13, k12, LOTRMod.stairsThatch, 1);
                this.setBlockAndMetadata(world, 5 - stair, j13, k12, LOTRMod.stairsThatch, 0);
            }
        }
        for (k14 = -4; k14 <= 5; ++k14) {
            for (i12 = -4; i12 <= 3; ++i12) {
                this.setBlockAndMetadata(world, i12, 5, k14, this.wood1Block, this.wood1Meta);
            }
        }
        for (int j14 = 1; j14 <= 5; ++j14) {
            for (int k18 : new int[]{-5, 6}) {
                this.setBlockAndMetadata(world, -5, j14, k18, this.beam1Block, this.beam1Meta);
                this.setBlockAndMetadata(world, -2, j14, k18, this.wood1Block, this.wood1Meta);
                this.setBlockAndMetadata(world, 1, j14, k18, this.wood1Block, this.wood1Meta);
                this.setBlockAndMetadata(world, 4, j14, k18, this.beam1Block, this.beam1Meta);
            }
            int[] i16 = new int[]{-5, 4};
            k12 = i16.length;
            for (k16 = 0; k16 < k12; ++k16) {
                i1 = i16[k16];
                this.setBlockAndMetadata(world, i1, j14, -1, this.beam1Block, this.beam1Meta);
                this.setBlockAndMetadata(world, i1, j14, 2, this.beam1Block, this.beam1Meta);
            }
        }
        for (k14 = 0; k14 <= 1; ++k14) {
            int[] i16 = new int[]{-5, 4};
            k12 = i16.length;
            for (k16 = 0; k16 < k12; ++k16) {
                i1 = i16[k16];
                this.setBlockAndMetadata(world, i1, 2, k14, this.wood1Block, this.wood1Meta);
                this.setBlockAndMetadata(world, i1, 4, k14, this.wood1Block, this.wood1Meta);
            }
        }
        int[] k19 = new int[]{-5, 6};
        i12 = k19.length;
        for (k12 = 0; k12 < i12; ++k12) {
            k16 = k19[k12];
            for (i1 = -1; i1 <= 0; ++i1) {
                this.setBlockAndMetadata(world, i1, 3, k16, this.wood1Block, this.wood1Meta);
                this.setBlockAndMetadata(world, i1, 5, k16, this.wood1Block, this.wood1Meta);
                this.setBlockAndMetadata(world, i1, 7, k16, LOTRMod.glassPane, 0);
            }
            for (i1 = -2; i1 <= 1; ++i1) {
                this.setBlockAndMetadata(world, i1, 0, k16, (Block)Blocks.field_150349_c, 0);
                for (int j15 = 1; j15 <= 3; ++j15) {
                    this.setBlockAndMetadata(world, i1, j15, k16, LOTRMod.gateWooden, 2);
                }
            }
        }
        for (i13 = -1; i13 <= 0; ++i13) {
            for (k13 = -6; k13 <= 7; ++k13) {
                this.setBlockAndMetadata(world, i13, 10, k13, LOTRMod.slabSingleThatch, 0);
            }
        }
        for (i13 = -3; i13 <= 2; ++i13) {
            this.setBlockAndMetadata(world, i13, 5, -6, this.wood1Stair, 6);
            this.setBlockAndMetadata(world, i13, 5, 7, this.wood1Stair, 7);
        }
        this.setBlockAndMetadata(world, -5, 5, -6, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, -4, 5, -6, this.wood1Stair, 4);
        this.setBlockAndMetadata(world, 3, 5, -6, this.wood1Stair, 5);
        this.setBlockAndMetadata(world, 4, 5, -6, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, -5, 5, 7, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, -4, 5, 7, this.wood1Stair, 4);
        this.setBlockAndMetadata(world, 3, 5, 7, this.wood1Stair, 5);
        this.setBlockAndMetadata(world, 4, 5, 7, this.wood1Block, this.wood1Meta);
        int[] i17 = new int[]{-4, 3};
        k13 = i17.length;
        for (k12 = 0; k12 < k13; ++k12) {
            int i18 = i17[k12];
            for (int k110 : new int[]{-1, 2}) {
                this.setBlockAndMetadata(world, i18, 1, k110, Blocks.field_150462_ai, 0);
                this.setBlockAndMetadata(world, i18, 2, k110, Blocks.field_150422_aJ, 0);
                this.setBlockAndMetadata(world, i18, 3, k110, Blocks.field_150422_aJ, 0);
                this.setBlockAndMetadata(world, i18, 4, k110, Blocks.field_150478_aa, 5);
            }
        }
        this.setBlockAndMetadata(world, -4, 1, -4, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -4, 2, -4, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -3, 1, -4, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -4, 1, -3, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -4, 1, 5, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -4, 2, 5, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -3, 1, 5, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -4, 1, 4, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, 3, 1, 5, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, 3, 2, 5, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, 2, 1, 5, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, 3, 1, 4, Blocks.field_150407_cf, 0);
        for (int j16 = 1; j16 <= 4; ++j16) {
            this.setBlockAndMetadata(world, 2, j16, -3, Blocks.field_150422_aJ, 0);
        }
        this.setBlockAndMetadata(world, 1, 1, -4, this.wood1Stair, 1);
        this.setBlockAndMetadata(world, 2, 1, -4, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, 2, 2, -4, this.wood1Stair, 1);
        this.setBlockAndMetadata(world, 3, 1, -4, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, 3, 2, -4, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, 3, 2, -3, this.wood1Stair, 7);
        this.setBlockAndMetadata(world, 3, 3, -3, this.wood1Stair, 2);
        this.setBlockAndMetadata(world, 3, 3, -2, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, 2, 3, -2, this.wood1Stair, 5);
        this.setBlockAndMetadata(world, 2, 4, -2, this.wood1Stair, 0);
        this.setBlockAndMetadata(world, 1, 4, -2, this.wood1Stair, 5);
        this.setBlockAndMetadata(world, 1, 5, -2, this.wood1Stair, 0);
        this.setAir(world, 3, 5, -4);
        this.setAir(world, 3, 5, -3);
        this.setAir(world, 3, 5, -2);
        this.setAir(world, 2, 5, -2);
        for (int i19 = 0; i19 <= 2; ++i19) {
            this.setBlockAndMetadata(world, i19, 6, -3, Blocks.field_150422_aJ, 0);
            this.setBlockAndMetadata(world, i19, 6, -1, Blocks.field_150422_aJ, 0);
        }
        this.setBlockAndMetadata(world, 2, 6, -4, Blocks.field_150422_aJ, 0);
        this.setBlockAndMetadata(world, 0, 6, -2, Blocks.field_150396_be, 3);
        for (k15 = -4; k15 <= 5; ++k15) {
            this.setBlockAndMetadata(world, -4, 6, k15, this.wood2Block, this.wood2Meta);
        }
        for (k15 = -1; k15 <= 5; ++k15) {
            this.setBlockAndMetadata(world, 3, 6, k15, this.wood2Block, this.wood2Meta);
        }
        this.setBlockAndMetadata(world, -2, 7, -4, Blocks.field_150478_aa, 3);
        this.setBlockAndMetadata(world, 1, 7, -4, Blocks.field_150478_aa, 3);
        this.setBlockAndMetadata(world, -2, 7, 5, Blocks.field_150478_aa, 4);
        this.setBlockAndMetadata(world, 1, 7, 5, Blocks.field_150478_aa, 4);
        int carpet = random.nextInt(16);
        this.setBlockAndMetadata(world, -1, 6, 2, Blocks.field_150404_cg, carpet);
        this.setBlockAndMetadata(world, 0, 6, 2, Blocks.field_150404_cg, carpet);
        this.setBlockAndMetadata(world, -1, 6, 3, Blocks.field_150404_cg, carpet);
        this.setBlockAndMetadata(world, 0, 6, 3, Blocks.field_150404_cg, carpet);
        for (k13 = 4; k13 <= 5; ++k13) {
            for (j1 = 6; j1 <= 7; ++j1) {
                this.setBlockAndMetadata(world, -3, j1, k13, Blocks.field_150342_X, 0);
                this.setBlockAndMetadata(world, 2, j1, k13, Blocks.field_150342_X, 0);
            }
        }
        this.setBlockAndMetadata(world, -3, 6, 0, this.wood2Block, this.wood2Meta);
        this.setBlockAndMetadata(world, -3, 7, 0, LOTRWorldGenHobbitStructure.getRandomCakeBlock(random), 0);
        this.setBlockAndMetadata(world, -3, 6, 1, (Block)Blocks.field_150383_bp, 3);
        this.setBlockAndMetadata(world, -3, 6, 2, LOTRMod.hobbitOven, 4);
        this.setBlockAndMetadata(world, -3, 6, 3, Blocks.field_150462_ai, 0);
        this.placeChest(world, random, 2, 6, 1, 5, LOTRChestContents.HOBBIT_HOLE_LARDER);
        this.setBlockAndMetadata(world, 2, 6, 2, Blocks.field_150324_C, 0);
        this.setBlockAndMetadata(world, 2, 6, 3, Blocks.field_150324_C, 8);
        for (i12 = 5; i12 <= 10; ++i12) {
            this.setBlockAndMetadata(world, i12, 1, -5, Blocks.field_150422_aJ, 0);
            this.setBlockAndMetadata(world, i12, 1, 6, Blocks.field_150422_aJ, 0);
        }
        for (k13 = -4; k13 <= 5; ++k13) {
            this.setBlockAndMetadata(world, 10, 1, k13, Blocks.field_150422_aJ, 0);
        }
        this.setBlockAndMetadata(world, 7, 1, -5, Blocks.field_150396_be, 0);
        this.setBlockAndMetadata(world, 5, 2, -5, Blocks.field_150478_aa, 5);
        this.setBlockAndMetadata(world, 10, 2, -5, Blocks.field_150478_aa, 5);
        this.setBlockAndMetadata(world, 10, 2, -1, Blocks.field_150478_aa, 5);
        this.setBlockAndMetadata(world, 10, 2, 2, Blocks.field_150478_aa, 5);
        this.setBlockAndMetadata(world, 5, 2, 6, Blocks.field_150478_aa, 5);
        this.setBlockAndMetadata(world, 10, 2, 6, Blocks.field_150478_aa, 5);
        for (i12 = 5; i12 <= 9; ++i12) {
            this.setBlockAndMetadata(world, i12, 0, -4, Blocks.field_150351_n, 0);
            this.setBlockAndMetadata(world, i12, 0, 5, Blocks.field_150351_n, 0);
        }
        for (k13 = -3; k13 <= 4; ++k13) {
            this.setBlockAndMetadata(world, 4, 0, k13, Blocks.field_150417_aV, 0);
            this.setBlockAndMetadata(world, 5, 0, k13, Blocks.field_150355_j, 0);
            this.setBlockAndMetadata(world, 5, 1, k13, (Block)Blocks.field_150333_U, 5);
            this.setBlockAndMetadata(world, 9, 0, k13, Blocks.field_150351_n, 0);
            for (i14 = 6; i14 <= 8; ++i14) {
                this.setBlockAndMetadata(world, i14, 0, k13, Blocks.field_150458_ak, 7);
                this.setBlockAndMetadata(world, i14, 1, k13, this.cropBlock, this.cropMeta);
            }
        }
        this.setBlockAndMetadata(world, 10, 2, 0, Blocks.field_150422_aJ, 0);
        this.setBlockAndMetadata(world, 10, 3, 0, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, 10, 4, 0, Blocks.field_150423_aK, 1);
        LOTREntityHobbitFarmer farmer = new LOTREntityHobbitFarmer(world);
        this.spawnNPCAndSetHome(farmer, world, 0, 6, 0, 16);
        int farmhands = 1 + random.nextInt(3);
        for (int l = 0; l < farmhands; ++l) {
            LOTREntityHobbitFarmhand farmhand = new LOTREntityHobbitFarmhand(world);
            farmhand.seedsItem = this.seedItem;
            this.spawnNPCAndSetHome(farmhand, world, 7, 1, 0, 8);
        }
        int animals = 3 + random.nextInt(6);
        for (int l = 0; l < animals; ++l) {
            Class animalClass = ((BiomeGenBase.SpawnListEntry)WeightedRandom.func_76271_a((Random)world.field_73012_v, (Collection)LOTRBiome.shire.func_76747_a((EnumCreatureType)EnumCreatureType.creature))).field_76300_b;
            EntityCreature animal = null;
            try {
                animal = (EntityCreature)animalClass.getConstructor(World.class).newInstance(world);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            this.spawnNPCAndSetHome(animal, world, 0, 1, 0, 8);
        }
        return true;
    }
}

